#ifndef __tcCounterThreadSafe_HPP__
#define __tcCounterThreadSafe_HPP__

#include "cCounter.hpp"

namespace Counter
{
    template<typename ResourceLocker_T>
    class tcCounter_ThreadSafe : public cCounter
    {
        public:
            tcCounter_ThreadSafe(uint32_t const CountValue = 0);
            ~tcCounter_ThreadSafe() =default;

            void setStartValue(uint32_t const StartValue);
            uint32_t getStartValue(void);
            void setCountToStartValue(void);

        private:
            ResourceLocker_T mResourceLocker;
    };

    template<typename ResourceLocker_T>
    tcCounter_ThreadSafe<ResourceLocker_T>::tcCounter_ThreadSafe(uint32_t const CountValue) :
        cCounter{ CountValue }
    {
        // no implementation
    }

    template<typename ResourceLocker_T>
    void tcCounter_ThreadSafe<ResourceLocker_T>::setStartValue(uint32_t const StartValue)
    {
        mResourceLocker.lock();
        cCounter::setStartValue(StartValue);
        mResourceLocker.unlock();
    }

    template<typename ResourceLocker_T>
    uint32_t tcCounter_ThreadSafe<ResourceLocker_T>::getStartValue(void)
    {
        uint32_t locTempValue = 0;

        mResourceLocker.lock();
        locTempValue = cCounter::getStartValue();
        mResourceLocker.unlock();

        return locTempValue;
    }

    template<typename ResourceLocker_T>
    void tcCounter_ThreadSafe<ResourceLocker_T>::setCountToStartValue(void)
    {
        mResourceLocker.lock();
        cCounter::setCountToStartValue();
        mResourceLocker.unlock();
    }
}

#endif  // __tcCounterThreadSafe_HPP__
