#include "Main_Application.hpp"

#include "../Counter/tcCounter_ThreadSafe.hpp"
#include "../Resource_Locker/cCriticalSection.hpp"
#include "../Resource_Locker/cMutex.hpp"

int main (void)
{
	configHardware();

	//Counter::tcCounter_ThreadSafe<ResourceLocker::cCriticalSection> locCounter_CriticalSection{ };
	//Counter::tcCounter_ThreadSafe<ResourceLocker::cMutex> locCounter_Mutex{ };

	//Counter::tcCounter_ThreadSafe<ResourceLocker::tcResourceLocker<ResourceLocker::cCriticalSection>> locCounter_CriticalSection{ };
	//Counter::tcCounter_ThreadSafe<ResourceLocker::tcResourceLocker<ResourceLocker::cMutex>> locCounter_Mutex{ };
	
	using namespace Counter;
	using namespace Resource_Locker;

	tcCounter_ThreadSafe<ticResourceLocker<cCriticalSection>> locCounter_CriticalSection{ };
	tcCounter_ThreadSafe<ticResourceLocker<cMutex>> locCounter_Mutex{ };
	
	while (true)
	{
		showValue("\nPolymorphism - CRTP:");
		showValue("\n<A> Count both counters");
		showValue("\n<B> Set locCounter_CriticalSection start value to 20");
		showValue("\n<C> Set locCounter_Mutex           start value to 30");
		showValue("\n<D> Set locCounter_CriticalSection count to start value");
		showValue("\n<E> Set locCounter_Mutex           count to start value");
		showValue("\n<Q> Returns form application");
		
		showValue("\nlocCounter_CriticalSection::mCountValue = ", locCounter_CriticalSection.getCountValue());
		showValue("\nlocCounter_CriticalSection::mStartValue = ", locCounter_CriticalSection.getStartValue());
		showValue("\nlocCounter_Mutex::mCountValue           = ", locCounter_Mutex.getCountValue());
		showValue("\nlocCounter_Mutex::mStartValue           = ", locCounter_Mutex.getStartValue());

		switch (getCommand())
		{
			case 'A':
				locCounter_CriticalSection.count();
				locCounter_Mutex.count();
				break;

			case 'B':
				locCounter_CriticalSection.setStartValue(20);
				break;

			case 'C':
				locCounter_Mutex.setStartValue(30);
				break;

			case 'D':
				locCounter_CriticalSection.setCountToStartValue();
				break;

			case 'E':
				locCounter_Mutex.setCountToStartValue();
				break;

			case 'Q':
				return 0;
				break;

			default:
				showValue("\nError: Unsupported selection!\n");
				break;
		}
	}
	//return 0;	
}
