#include "cCounter_ThreadSafe.hpp"

#include "../Resource_Locker/icResourceLocker.hpp"

namespace Counter
{
    cCounter_ThreadSafe::cCounter_ThreadSafe(icResourceLocker* const ptrResourceLocker, uint32_t const CountValue) :
        cCounter{ CountValue },
        mptrResourceLocker{ ptrResourceLocker }
    {
        // no implementation
    }

    void cCounter_ThreadSafe::setStartValue(uint32_t const StartValue)
    {
        if (mptrResourceLocker != nullptr)
        {
            mptrResourceLocker->lock();
        }

        cCounter::setStartValue(StartValue);

        if (mptrResourceLocker != nullptr)
        {
            mptrResourceLocker->unlock();
        }
    }

    uint32_t cCounter_ThreadSafe::getStartValue(void)
    {
        uint32_t locTempValue = 0;

        if (mptrResourceLocker != nullptr)
        {
            mptrResourceLocker->lock();
        }

        locTempValue = cCounter::getStartValue();
        
        if (mptrResourceLocker != nullptr)
        {
            mptrResourceLocker->unlock();
        }

        return locTempValue;
    }

    void cCounter_ThreadSafe::setCountToStartValue(void)
    {
        if (mptrResourceLocker != nullptr)
        {
            mptrResourceLocker->lock();
        }

        cCounter::setCountToStartValue();
        
        if (mptrResourceLocker != nullptr)
        {
            mptrResourceLocker->unlock();
        }
    }

    void cCounter_ThreadSafe::setResourceLocker(icResourceLocker* const ptrResourceLocker)
    {
        mptrResourceLocker = ptrResourceLocker;
    }
}

