#include "Main_Application.hpp"

#include "../Counter/cCounter_ThreadSafe.hpp"
#include "../Resource_Locker/cCriticalSection.hpp"
#include "../Resource_Locker/cMutex.hpp"

int main(void)
{
	configHardware();

	Resource_Locker::cCriticalSection locCriticalSection{ };
	Resource_Locker::cMutex locMutex{ };

	Counter::cCounter_ThreadSafe locCounter_A{ &locCriticalSection };
	Counter::cCounter_ThreadSafe locCounter_B{ &locMutex };
	
	while (true)
	{
		showValue("\nPolymorphism - Interface and Association:");
		showValue("\n<A> Count both counters");
		showValue("\n<B> Set locCounter_A start value to 20");
		showValue("\n<C> Set locCounter_B start value to 30");
		showValue("\n<D> Set locCounter_A count to start value");
		showValue("\n<E> Set locCounter_B count to start value");
		showValue("\n<F> Change      resource locking mechanism");
		showValue("\n<G> Change back resource locking mechanism");
		showValue("\n<Q> Return form application");
		
		showValue("\nlocCounter_A::mCountValue = ", locCounter_A.getCountValue());
		showValue("\nlocCounter_A::mStartValue = ", locCounter_A.getStartValue());
		showValue("\nlocCounter_B::mCountValue = ", locCounter_B.getCountValue());
		showValue("\nlocCounter_B::mStartValue = ", locCounter_B.getStartValue());

		switch (getCommand())
		{
			case 'A':
				locCounter_A.count();
				locCounter_B.count();
				break;

			case 'B':
				locCounter_A.setStartValue(20);
				break;

			case 'C':
				locCounter_B.setStartValue(30);
				break;

			case 'D':
				locCounter_A.setCountToStartValue();
				break;

			case 'E':
				locCounter_B.setCountToStartValue();
				break;

			case 'F':
				locCounter_A.setResourceLocker(&locMutex);
				locCounter_B.setResourceLocker(&locCriticalSection);
				break;

			case 'G':
				locCounter_A.setResourceLocker(&locCriticalSection);
				locCounter_B.setResourceLocker(&locMutex);
				break;

			case 'Q':
				return 0;
				break;

			default:
				showValue("\nError: Unsupported selection!\n");
				break;
		}
	}
	//return 0;	
}
