#ifndef __icCounter_HPP__
#define __icCounter_HPP__

#include "TypeDefinitions.hpp"

namespace Interface
{
	class icCounter
	{
		public:
			virtual uint32_t getCountValue(void) const = 0;
			virtual uint32_t getStartValue(void) const = 0;
			virtual uint32_t getBoundaryValue(void) const = 0;

			virtual void reset(void) = 0;
			virtual void count(void) = 0;

		protected:
			icCounter() = default;
			virtual ~icCounter() = default;
	};
}

#endif  // __icCounter_HPP__
