#include "cInBound.hpp"

namespace Counter
{
	cInBound::cInBound() noexcept : mptr_icCounter(nullptr)
	{
		// nothing to do
	}

	uint32_t cInBound::getCountValue(void) const noexcept
	{
		uint32_t locReturnValue = 0;

		if (mptr_icCounter != nullptr)
		{
			locReturnValue = mptr_icCounter->getCountValue();
		}

		return locReturnValue;
	}

	uint32_t cInBound::getStartValue(void) const noexcept
	{
		uint32_t locReturnValue = 0;

		if (mptr_icCounter != nullptr)
		{
			locReturnValue = mptr_icCounter->getStartValue();
		}

		return locReturnValue;
	}

	uint32_t cInBound::getBoundaryValue(void) const noexcept
	{
		uint32_t locReturnValue = 0;

		if (mptr_icCounter != nullptr)
		{
			locReturnValue = mptr_icCounter->getBoundaryValue();
		}

		return locReturnValue;
	}

	void cInBound::reset(void) noexcept
	{
		if (mptr_icCounter != nullptr)
		{
			mptr_icCounter->reset();
		}
	}

	void cInBound::count(void) noexcept
	{
		if (mptr_icCounter != nullptr)
		{
			mptr_icCounter->count();
		}
	}

	void cInBound::set_mptr_icCounter(icCounter* const ptr_icCounter) noexcept
	{
		mptr_icCounter = ptr_icCounter;
	}
}
