#ifndef __cCounter_HPP__
#define __cCounter_HPP__

#include "..\Interface\icCounter.hpp"
using Interface::icCounter;

#include "pcCounter.hpp"

namespace Counter
{
	class cCounter : public icCounter
	{
		public:
			uint32_t getCountValue(void) const noexcept override;
			uint32_t getStartValue(void) const noexcept override;
			uint32_t getBoundaryValue(void) const noexcept override;

			void reset(void) noexcept override;
			void count(void) noexcept override =0;
			
			pcCounter* get_mPortCounter(void) const noexcept;

		protected:
			pcCounter mPortCounter;

			uint32_t mCountValue;
			const uint32_t mStartValue;
			const uint32_t mBoundaryValue;

			explicit cCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept;
			virtual ~cCounter() noexcept =default;
	};
}
#endif  // __cCounter_HPP__
