#include "cCounter.hpp"

namespace Counter
{
	cCounter::cCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept :
		mCountValue(StartValue),
		mStartValue(StartValue),
		mBoundaryValue(BoundaryValue)
	{
		mPortCounter.get_mInBound()->set_mptr_icCounter(this);
	}
	
	uint32_t cCounter::getCountValue(void) const noexcept
	{
		return mCountValue;
	}

	uint32_t cCounter::getStartValue(void) const noexcept
	{
		return mStartValue;
	}

	uint32_t cCounter::getBoundaryValue(void) const noexcept
	{
		return mBoundaryValue;
	}

	void cCounter::reset() noexcept
	{
		mCountValue = mStartValue;
	}

	pcCounter* cCounter::get_mPortCounter(void) const noexcept
	{
		return const_cast<pcCounter*>(&mPortCounter);
	}
}
