#include "cOutBound.hpp"

namespace Controller
{
	cOutBound::cOutBound() noexcept : mptr_icCounter(nullptr)
	{
		// nothing to do
	}

	uint32_t cOutBound::getCountValue(void) const noexcept
	{
		uint32_t locReturnValue = 0;

		if (mptr_icCounter != nullptr)
		{
			locReturnValue = mptr_icCounter->getCountValue();
		}

		return locReturnValue;
	}

	uint32_t cOutBound::getStartValue(void) const noexcept
	{
		uint32_t locReturnValue = 0;

		if (mptr_icCounter != nullptr)
		{
			locReturnValue = mptr_icCounter->getStartValue();
		}

		return locReturnValue;
	}

	uint32_t cOutBound::getBoundaryValue(void) const noexcept
	{
		uint32_t locReturnValue = 0;

		if (mptr_icCounter != nullptr)
		{
			locReturnValue = mptr_icCounter->getBoundaryValue();
		}

		return locReturnValue;
	}

	void cOutBound::reset(void) noexcept
	{
		if (mptr_icCounter != nullptr)
		{
			mptr_icCounter->reset();
		}
	}

	void cOutBound::count(void) noexcept
	{
		if (mptr_icCounter != nullptr)
		{
			mptr_icCounter->count();
		}
	}
	
	void cOutBound::set_ptr_icCounter(icCounter* const ptr_icCounter) noexcept
	{
		mptr_icCounter = ptr_icCounter;
	}

	icCounter* cOutBound::get_mptr_icCounter(void) const noexcept
	{
		return const_cast<icCounter*>(mptr_icCounter);
	}
}
