#include "cController.hpp"

#include "..\..\Plattform\HAL\BasicIO.hpp"
using namespace Plattform::HAL;

namespace Controller
{
	pcController* cController::get_mPortController(uint32_t const Index) const noexcept
	{
		const pcController* locReturnValue = nullptr;

		if (Index < mArrayLength)
		{
			locReturnValue = &mPortController[Index];
		}

		return const_cast<pcController*>(locReturnValue);
	}

	void cController::control(void) noexcept
	{
		while (true)
		{
			controlOutput();
			controlInput();
		}
	}

	void cController::controlOutput(void) noexcept
	{
		showValue("\nPort Implementation - Interface Virtual:");
		if (mPortController[0].isConnected())
		{
			showValue("\nFirst  counter:");
			showValue("\n CountValue    = ", mPortController[0].get_mOutBound()->getCountValue());
			showValue("\n StartValue    = ", mPortController[0].get_mOutBound()->getStartValue());
			showValue("\n BoundaryValue = ", mPortController[0].get_mOutBound()->getBoundaryValue());
		}
		if (mPortController[1].isConnected())
		{
			showValue("\nSecond counter:");
			showValue("\n CountValue    = ", mPortController[1].get_mOutBound()->getCountValue());
			showValue("\n StartValue    = ", mPortController[1].get_mOutBound()->getStartValue());
			showValue("\n BoundaryValue = ", mPortController[1].get_mOutBound()->getBoundaryValue());
 		}
		showValue("\n<A> Count first  counter");
		showValue("\n<B> Reset first  counter");
		showValue("\n<C> Count second counter");
		showValue("\n<D> Reset second counter");
	}

	void cController::controlInput(void) noexcept
	{
		switch (getCommand())
		{
			case 'A':
				if (mPortController[0].isConnected())
				{
					mPortController[0].get_mOutBound()->count();
				}
				break;

			case 'B':
				if (mPortController[0].isConnected())
				{
					mPortController[0].get_mOutBound()->reset();
				}
				break;

			case 'C':
				if (mPortController[1].isConnected())
				{
					mPortController[1].get_mOutBound()->count();
				}
				break;

			case 'D':
				if (mPortController[1].isConnected())
				{
					mPortController[1].get_mOutBound()->reset();
				}
				break;

			default:
				showValue("\nError: Unsupported selection!\n");
				break;
		}
	}
}
