#ifndef __icCounter_H__
#define __icCounter_H__

#include "TypeDefinitions.h"

typedef struct _icCounter icCounter;

typedef struct _icCounterVMT
{
	uint32_t (*getCountValue)(const icCounter* const ptrCounter);
	uint32_t (*getStartValue)(const icCounter* const ptrCounter);
	uint32_t (*getBoundaryValue)(const icCounter* const ptrCounter);
	void (*reset)(icCounter* const ptrCounter);
	void (*count)(icCounter* const ptrCounter);
} icCounterVMT;

typedef struct _icCounter
{
	icCounterVMT* mptr_icCounterVMT;
} icCounter;

void icCounter_construct(icCounter* const ptrCounter);
void icCounter_destruct(icCounter* const ptrCounter);
			
uint32_t icCounter_getCountValue(const icCounter* const ptrCounter);
uint32_t icCounter_getStartValue(const icCounter* const ptrCounter);
uint32_t icCounter_getBoundaryValue(const icCounter* const ptrCounter);

void icCounter_reset(icCounter* const ptrCounter);
void icCounter_count(icCounter* const ptrCounter);

#endif  // __icCounter_H__
