#include "icCounter.h"

static icCounterVMT glob_icCounterVMT =
{
	.getCountValue    = nullptr,
	.getStartValue    = nullptr,
	.getBoundaryValue = nullptr,
	.reset            = nullptr,
	.count            = nullptr
};

void icCounter_construct(icCounter* const ptrCounter)
{
	ptrCounter->mptr_icCounterVMT = &glob_icCounterVMT;
}

void icCounter_destruct(icCounter* const ptrCounter)
{
	// no implementation
}
			
uint32_t icCounter_getCountValue(const icCounter* const ptrCounter)
{
	return ptrCounter->mptr_icCounterVMT->getCountValue(ptrCounter);
}

uint32_t icCounter_getStartValue(const icCounter* const ptrCounter)
{
	return ptrCounter->mptr_icCounterVMT->getStartValue(ptrCounter);
}

uint32_t icCounter_getBoundaryValue(const icCounter* const ptrCounter)
{
	return ptrCounter->mptr_icCounterVMT->getBoundaryValue(ptrCounter);
}

void icCounter_reset(icCounter* const ptrCounter)
{
	ptrCounter->mptr_icCounterVMT->reset(ptrCounter);
}

void icCounter_count(icCounter* const ptrCounter)
{
	ptrCounter->mptr_icCounterVMT->count(ptrCounter);
}
