#include "cUpCounter.h"

static bool cUpCounter_isInRange(const cUpCounter* const ptrUpCounter);
static void cUpCounter_count_raw(cUpCounter* const ptrUpCounter);

static cUpCounterVMT glob_cUpCounterVMT =
{
	.getCountValue = (uint32_t(*)(const icCounter* const))cCounter_getCountValue,
	.getStartValue = (uint32_t(*)(const icCounter* const))cCounter_getStartValue,
	.getBoundaryValue = (uint32_t(*)(const icCounter* const))cCounter_getBoundaryValue,
	.reset = (void(*)(icCounter* const))cCounter_reset,
	.count = (void(*)(icCounter* const))cUpCounter_count
};

void cUpCounter_construct(cUpCounter* const ptrUpCounter, const uint32_t StartValue, const uint32_t BoundaryValue)
{
	cCounter_construct((cCounter*)ptrUpCounter, StartValue, BoundaryValue);
	ptrUpCounter->mBaseCounter.mBase_icCounter.mptr_icCounterVMT = &glob_cUpCounterVMT;
}

void cUpCounter_destruct(cUpCounter* const ptrUpCounter)
{
	// no implementation
}

void cUpCounter_count(cUpCounter* const ptrUpCounter)
{
	if (cUpCounter_isInRange(ptrUpCounter))
	{
		cUpCounter_count_raw(ptrUpCounter);
	}
	else
	{
		cCounter_reset((cCounter*)ptrUpCounter);
	}
}

static bool cUpCounter_isInRange(const cUpCounter* const ptrUpCounter)
{
	bool locStatus = false;

	if ( (cCounter_getStartValue((cCounter*)ptrUpCounter) != cCounter_getBoundaryValue((cCounter*)ptrUpCounter)) &&
		 (cCounter_getCountValue((cCounter*)ptrUpCounter)  < cCounter_getBoundaryValue((cCounter*)ptrUpCounter)) )
	{
		locStatus = true;
	}
	else
	{
		locStatus = false;
	}

	return locStatus;
}

static void cUpCounter_count_raw(cUpCounter* const ptrUpCounter)
{
	uint32_t locCountValue = cCounter_getCountValue((cCounter*)ptrUpCounter);
	locCountValue++;
	cCounter_setCountValue((cCounter*)ptrUpCounter, locCountValue);
}
