#include "cDownCounter.h"

static bool cDownCounter_isInRange(const cDownCounter* const ptrDownCounter);
static void cDownCounter_count_raw(cDownCounter* const ptrDownCounter);

static cDownCounterVMT glob_cDownCounterVMT =
{
	.getCountValue = (uint32_t(*)(const icCounter* const))cCounter_getCountValue,
	.getStartValue = (uint32_t(*)(const icCounter* const))cCounter_getStartValue,
	.getBoundaryValue = (uint32_t(*)(const icCounter* const))cCounter_getBoundaryValue,
	.reset = (void(*)(icCounter* const))cCounter_reset,
	.count = (void(*)(icCounter* const))cDownCounter_count
};

void cDownCounter_construct(cDownCounter* const ptrDownCounter, const uint32_t StartValue, const uint32_t BoundaryValue)
{
	cCounter_construct((cCounter*)ptrDownCounter, StartValue, BoundaryValue);
	ptrDownCounter->mBaseCounter.mBase_icCounter.mptr_icCounterVMT = &glob_cDownCounterVMT;
}

void cDownCounter_destruct(cDownCounter* const ptrDownCounter)
{
	// no implementation
}

void cDownCounter_count(cDownCounter* const ptrDownCounter)
{
	if (cDownCounter_isInRange(ptrDownCounter))
	{
		cDownCounter_count_raw(ptrDownCounter);
	}
	else
	{
		cCounter_reset((cCounter*)ptrDownCounter);
	}
}

static bool cDownCounter_isInRange(const cDownCounter* const ptrDownCounter)
{
	bool locStatus = false;

	if ((cCounter_getStartValue((cCounter*)ptrDownCounter) != cCounter_getBoundaryValue((cCounter*)ptrDownCounter)) &&
		(cCounter_getCountValue((cCounter*)ptrDownCounter)  > cCounter_getBoundaryValue((cCounter*)ptrDownCounter)))
	{
		locStatus = true;
	}
	else
	{
		locStatus = false;
	}

	return locStatus;
}

static void cDownCounter_count_raw(cDownCounter* const ptrDownCounter)
{
	uint32_t locCountValue = cCounter_getCountValue((cCounter*)ptrDownCounter);
	locCountValue--;
	cCounter_setCountValue((cCounter*)ptrDownCounter, locCountValue);
}

