#ifndef __cCounter_H__
#define __cCounter_H__

#include "icCounter.h"

typedef icCounterVMT cCounterVMT;

typedef struct _cCounter
{
	icCounter mBase_icCounter;
	uint32_t mCountValue;
	uint32_t mStartValue;
	uint32_t mBoundaryValue;
} cCounter;

void cCounter_construct(cCounter* const ptrCounter, const uint32_t StartValue, const uint32_t BoundaryValue);
void cCounter_destruct(cCounter* const ptrCounter);

uint32_t cCounter_getCountValue(const cCounter* const ptrCounter);
uint32_t cCounter_getStartValue(const cCounter* const ptrCounter);
uint32_t cCounter_getBoundaryValue(const cCounter* const ptrCounter);

void cCounter_setCountValue(cCounter* const ptrCounter, uint32_t CountValue);

void cCounter_reset(cCounter* const ptrCounter);

#endif  // __cCounter_H__
