#include "cCounter.h"

static cCounterVMT glob_cCounterVMT =
{
	.getCountValue    = (uint32_t(*)(const icCounter* const))cCounter_getCountValue,
	.getStartValue    = (uint32_t(*)(const icCounter* const))cCounter_getStartValue,
	.getBoundaryValue = (uint32_t(*)(const icCounter* const))cCounter_getBoundaryValue,
	.reset            = (void(*)(icCounter* const))cCounter_reset,
	.count = nullptr
};

void cCounter_construct(cCounter* const ptrCounter, const uint32_t StartValue, const uint32_t BoundaryValue)
{
	icCounter_construct((icCounter*)ptrCounter);
	ptrCounter->mBase_icCounter.mptr_icCounterVMT = &glob_cCounterVMT;
	ptrCounter->mCountValue    = StartValue;
	ptrCounter->mStartValue    = StartValue;
	ptrCounter->mBoundaryValue = BoundaryValue;
}

void cCounter_destruct(cCounter* const ptrCounter)
{
	// no implementation
}

uint32_t cCounter_getCountValue(const cCounter* const ptrCounter)
{
	return ptrCounter->mCountValue;
}

uint32_t cCounter_getStartValue(const cCounter* const ptrCounter)
{
	return ptrCounter->mStartValue;
}

uint32_t cCounter_getBoundaryValue(const cCounter* const ptrCounter)
{
	return ptrCounter->mBoundaryValue;
}

void cCounter_setCountValue(cCounter* const ptrCounter, uint32_t CountValue)
{
	ptrCounter->mCountValue = CountValue;
}

void cCounter_reset(cCounter* const ptrCounter)
{
	ptrCounter->mCountValue = ptrCounter->mStartValue;
}
