#include "cController.h"
#include "..\Counter\icCounter.h"

#include "..\..\Plattform\HAL\BasicIO.h"

static void cController_controlOutput(const cController* const ptrController);
static void cController_controlInput(cController* const ptrController);

void cController_construct(cController* const ptrController)
{
	uint32_t locIndex = 0;

	for (locIndex = 0; locIndex < mArrayLength; locIndex++)
	{
		ptrController->mptr_icCounter[locIndex] = nullptr;
	}
}

void cController_destruct(cController* const ptrController)
{
	// no implementation
}

void cController_set_ptr_icCounter(cController* const ptrController, icCounter* const ptr_icCounter, const uint32_t Index)
{
	if (Index < mArrayLength)
	{
		ptrController->mptr_icCounter[Index] = ptr_icCounter;
	}
}

void cController_control(cController* const ptrController)
{
	while (true)
	{
		cController_controlOutput(ptrController);
		cController_controlInput(ptrController);
	}
}

static void cController_controlOutput(const cController* const ptrController)
{
	showValue("\nControl Cases - Interface Virtual:");
	if (ptrController->mptr_icCounter[0] != nullptr)
	{
		showValue("\nFirst  counter:");
		showValue("\n CountValue    = %u", icCounter_getCountValue((icCounter*)ptrController->mptr_icCounter[0]));
		showValue("\n StartValue    = %u", icCounter_getStartValue((icCounter*)ptrController->mptr_icCounter[0]));
		showValue("\n BoundaryValue = %u", icCounter_getBoundaryValue((icCounter*)ptrController->mptr_icCounter[0]));
	}
	if (ptrController->mptr_icCounter[1] != nullptr)
	{
		showValue("\nSecond counter:");
		showValue("\n CountValue    = %u", icCounter_getCountValue((icCounter*)ptrController->mptr_icCounter[1]));
		showValue("\n StartValue    = %u", icCounter_getStartValue((icCounter*)ptrController->mptr_icCounter[1]));
		showValue("\n BoundaryValue = %u", icCounter_getBoundaryValue((icCounter*)ptrController->mptr_icCounter[1]));
	}
	showValue("\n<A> Count first  counter");
	showValue("\n<B> Reset first  counter");
	showValue("\n<C> Count second counter");
	showValue("\n<D> Reset second counter");
}

void cController_controlInput(cController* const ptrController)
{
	switch (getCommand())
	{
		case 'A':
			if (ptrController->mptr_icCounter[0] != nullptr)
			{
				icCounter_count((icCounter*)ptrController->mptr_icCounter[0]);
			}
			break;

		case 'B':
			if (ptrController->mptr_icCounter[0] != nullptr)
			{
				icCounter_reset((icCounter*)ptrController->mptr_icCounter[0]);
			}
			break;

		case 'C':
			if (ptrController->mptr_icCounter[1] != nullptr)
			{
				icCounter_count((icCounter*)ptrController->mptr_icCounter[1]);
			}
			break;

		case 'D':
			if (ptrController->mptr_icCounter[1] != nullptr)
			{
				icCounter_reset((icCounter*)ptrController->mptr_icCounter[1]);
			}
			break;

		default:
			showValue("\nError: Unsupported selection!\n");
			break;
	}
}
