#ifndef __icCounter_H__
#define __icCounter_H__

#include "TypeDefinitions.h"

typedef struct _icCounter icCounter;

typedef	struct _icCounterVMT
{
	bool (*isInRange)(const icCounter* const ptrCounter);
	void (*count_raw)(icCounter* const trCounter);
} icCounterVMT;

typedef	struct _icCounter
{
	icCounterVMT* mptr_icCounterVMT;
	uint32_t mCountValue;
	uint32_t mStartValue;
	uint32_t mBoundaryValue;
} icCounter;
		
void icCounter_construct(icCounter* const ptrCounter, const uint32_t StartValue, const uint32_t BondaryValue);
void icCounter_destruct(icCounter* const ptrCounter);
			
uint32_t icCounter_getCountValue(const icCounter* const ptrCounter);
uint32_t icCounter_getStartValue(const icCounter* const ptrCounter);
uint32_t icCounter_getBoundaryValue(const icCounter* const ptrCounter);

void icCounter_setCountValue(icCounter* const ptrCounter, uint32_t CountValue);

void icCounter_reset(icCounter* const icCounter);
void icCounter_count(icCounter* const icCounter);

#endif  // __icCounter_H__
