#include "icCounter.h"

static icCounterVMT glob_icCounterVMT =
{
	.isInRange = nullptr,
	.count_raw = nullptr
};

void icCounter_construct(icCounter* const ptrCounter, const uint32_t StartValue, const uint32_t BoundaryValue)
{
	ptrCounter->mptr_icCounterVMT = &glob_icCounterVMT;

	ptrCounter->mCountValue    = StartValue;
	ptrCounter->mStartValue    = StartValue;
	ptrCounter->mBoundaryValue = BoundaryValue;
}

void icCounter_destruct(icCounter* const ptrCounter)
{
	// no implementation
}
	
uint32_t icCounter_getCountValue(const icCounter* const ptrCounter)
{
	return ptrCounter->mCountValue;
}
		
uint32_t icCounter_getStartValue(const icCounter* const ptrCounter)
{
	return ptrCounter->mStartValue;
}
	
uint32_t icCounter_getBoundaryValue(const icCounter* const ptrCounter)
{
	return ptrCounter->mBoundaryValue;
}

void icCounter_setCountValue(icCounter* const ptrCounter, uint32_t CountValue)
{
	ptrCounter->mCountValue = CountValue;
}
	
void icCounter_reset(icCounter* const ptrCounter)
{
	ptrCounter->mCountValue = ptrCounter->mStartValue;
}

void icCounter_count(icCounter* const ptrCounter)
{
	if (ptrCounter->mptr_icCounterVMT->isInRange(ptrCounter))
	{
		ptrCounter->mptr_icCounterVMT->count_raw(ptrCounter);
	}
	else
	{
		icCounter_reset(ptrCounter);
	}
}
