#include "cUpCounter.h"

static bool cUpCounter_isInRange(const cUpCounter* const ptrUpCounter);
static void cUpCounter_count_raw(cUpCounter* const ptrUpCounter);

static cUpCounterVMT glob_cUpCounterVMT =
{
	.isInRange = (bool(*)(const icCounter* const))cUpCounter_isInRange,
	.count_raw = (void(*)(icCounter* const))cUpCounter_count_raw
};

void cUpCounter_construct(cUpCounter* const ptrUpCounter, const uint32_t StartValue, const uint32_t BoundaryValue)
{
	icCounter_construct((icCounter*)ptrUpCounter, StartValue, BoundaryValue);
	ptrUpCounter->mBase_icCounter.mptr_icCounterVMT = &glob_cUpCounterVMT;
}

void cUpCounter_destruct(cUpCounter* const ptrUpCounter)
{
	// no implememntation
}

static bool cUpCounter_isInRange(const cUpCounter* const ptrUpCounter)
{
	bool locStatus = false;

	if ( (icCounter_getStartValue((icCounter*)ptrUpCounter) != icCounter_getBoundaryValue((icCounter*)ptrUpCounter)) &&
		 (icCounter_getCountValue((icCounter*)ptrUpCounter)  < icCounter_getBoundaryValue((icCounter*)ptrUpCounter)) )
	{
		locStatus = true;
	}
	else
	{
		locStatus = false;
	}

	return locStatus;
}
	
static void cUpCounter_count_raw(cUpCounter* const ptrUpCounter)
{
	uint32_t locCountValue = icCounter_getCountValue((icCounter*)ptrUpCounter);
	locCountValue++;
	icCounter_setCountValue((icCounter*)ptrUpCounter, locCountValue);
}
