#include "cDownCounter.h"

static bool cDownCounter_isInRange(const cDownCounter* const ptrDownCounter);
static void cDownCounter_count_raw(cDownCounter* const ptrDownCounter);

static cDownCounterVMT glob_cDownCounterVMT =
{
	.isInRange = (bool(*)(const icCounter* const))cDownCounter_isInRange,
	.count_raw = (void(*)(icCounter* const))cDownCounter_count_raw
};

void cDownCounter_construct(cDownCounter* const ptrDownCounter, const uint32_t StartValue, const uint32_t BoundaryValue)
{
	icCounter_construct((icCounter*)ptrDownCounter, StartValue, BoundaryValue);
	ptrDownCounter->mBase_icCounter.mptr_icCounterVMT = &glob_cDownCounterVMT;
}

void cDownCounter_destruct(cDownCounter* const ptrDownCounter, const uint32_t StartValue, const uint32_t BoundaryValue)
{
	// no implementation
}

static bool cDownCounter_isInRange(const cDownCounter* const ptrDownCounter)
{
	bool locStatus = false;

	if ( (icCounter_getStartValue((icCounter*)ptrDownCounter) != icCounter_getBoundaryValue((icCounter*)ptrDownCounter)) &&
		 (icCounter_getCountValue((icCounter*)ptrDownCounter)  > icCounter_getBoundaryValue((icCounter*)ptrDownCounter)) )
	{
		locStatus = true;
	}
	else
	{
		locStatus = false;
	}

	return locStatus;
}
	
static void cDownCounter_count_raw(cDownCounter* const ptrDownCounter)
{
	uint32_t locCountValue = icCounter_getCountValue((icCounter*)ptrDownCounter);
	locCountValue--;
	icCounter_setCountValue((icCounter*)ptrDownCounter, locCountValue);
}

