#ifndef __tcBoundaryChecker_H__
#define __tcBoundaryChecker_H__

#include "Typedefinitions.h"

#define Type_T uint32_t

typedef struct _tcBoundaryChecker
{
	Type_T mMinValue;
	Type_T mMaxValue;
} tcBoundaryChecker;
			
void tcBoundaryChecker_construct(tcBoundaryChecker* const ptrBoundaryChecker, const Type_T MinValue, const Type_T MaxValue);
void tcBoundaryChecker_destruct(tcBoundaryChecker* const ptrBoundaryChecker);

void tcBoundaryChecker_setMinValue(tcBoundaryChecker* const ptrBoundaryChecker, const Type_T MinValue);
void tcBoundaryChecker_setMaxValue(tcBoundaryChecker* const ptrBoundaryChecker, const Type_T MaxValue);

Type_T tcBoundaryChecker_getMinValue(const tcBoundaryChecker* const ptrBoundaryChecker);
Type_T tcBoundaryChecker_getMaxValue(const tcBoundaryChecker* const ptrBoundaryChecker);
			
bool tcBoundaryChecker_isInRange(const tcBoundaryChecker* const ptrBoundaryChecker, const Type_T ValueToCheck);

#endif  // __tcBoundryChecker_H__
