#include "tcBoundaryChecker.h"

void tcBoundaryChecker_construct(tcBoundaryChecker* const ptrBoundaryChecker, const Type_T MinValue, const Type_T MaxValue)
{
	ptrBoundaryChecker->mMinValue = MinValue;
	ptrBoundaryChecker->mMaxValue = MaxValue;
}

void tcBoundaryChecker_destruct(tcBoundaryChecker* const ptrBoundaryChecker)
{
	// no implementation
}

void tcBoundaryChecker_setMinValue(tcBoundaryChecker* const ptrBoundaryChecker, const Type_T MinValue)
{
	ptrBoundaryChecker->mMinValue = MinValue;
}

void tcBoundaryChecker_setMaxValue(tcBoundaryChecker* const ptrBoundaryChecker, const Type_T MaxValue)
{
	ptrBoundaryChecker->mMaxValue = MaxValue;
}

Type_T tcBoundaryChecker_getMinValue(const tcBoundaryChecker* const ptrBoundaryChecker)
{
	return ptrBoundaryChecker->mMinValue;
}
	
Type_T tcBoundaryChecker_getMaxValue(const tcBoundaryChecker* const ptrBoundaryChecker)
{
	return ptrBoundaryChecker->mMaxValue;
}

bool tcBoundaryChecker_isInRange(const tcBoundaryChecker* const ptrBoundaryChecker, const Type_T ValueToCheck)
{
	bool locStatus = false;

	if ( (ptrBoundaryChecker->mMinValue < ptrBoundaryChecker->mMaxValue) &&
			(ValueToCheck > ptrBoundaryChecker->mMinValue) &&
			(ValueToCheck < ptrBoundaryChecker->mMaxValue) )
	{
		locStatus = true;
	}
	else
	{
		locStatus = false;
	}

	return locStatus;
}
