#ifndef __icCounter_H__
#define __icCounter_H__

#include "TypeDefinitions.h"

#include "cCounter.h"
#include "tcBoundaryChecker.h"

typedef struct _icCounter
{
	uint32_t mBoundaryValue;
	cCounter mobjCounter;
	tcBoundaryChecker mobjBoundaryChecker;
} icCounter;
		
void icCounter_construct(icCounter* const ptrCounter, const uint32_t StartValue, const uint32_t BoundaryValue, const int32_t StepValue);
void icCounter_destruct(icCounter* const ptrCounter);
			
uint32_t icCounter_getCountValue(const icCounter* const ptrCounter);
uint32_t icCounter_getStartValue(const icCounter* const ptrCounter);
uint32_t icCounter_getBoundaryValue(const icCounter* const ptrCounter);

void icCounter_reset(icCounter* const ptrCounter);
void icCounter_count(icCounter* const ptrCounter);

#endif  // __icCounter_H__
