#include "icCounter.h"

#include "..\..\Plattform\HAL\BasicIO.h"

static bool icCounter_isInRange(const icCounter* const ptrCounter);


void icCounter_construct(icCounter* const ptrCounter, const uint32_t StartValue, const uint32_t BoundaryValue, const int32_t StepValue)
{
	ptrCounter->mBoundaryValue = BoundaryValue;
	cCounter_construct(&ptrCounter->mobjCounter, StartValue, StepValue);

	tcBoundaryChecker_construct(&ptrCounter->mobjBoundaryChecker,
		(StartValue < BoundaryValue) ? StartValue : (StartValue > BoundaryValue) ? BoundaryValue : 0,
		(StartValue < BoundaryValue) ? BoundaryValue : (StartValue > BoundaryValue) ? StartValue : 0);

	showValue("\nMinValue = %u", tcBoundaryChecker_getMinValue(&ptrCounter->mobjBoundaryChecker));
	showValue("\nMaxValue = %u", tcBoundaryChecker_getMaxValue(&ptrCounter->mobjBoundaryChecker));
}

void icCounter_destruct(icCounter* const ptrCounter)
{
	// no implementation
}

uint32_t icCounter_getCountValue(const icCounter* const ptrCounter)
{
	return cCounter_getCountValue(&ptrCounter->mobjCounter);
}

uint32_t icCounter_getStartValue(const icCounter* const ptrCounter)
{
	return cCounter_getStartValue(&ptrCounter->mobjCounter);
}

uint32_t icCounter_getBoundaryValue(const icCounter* const ptrCounter)
{
	return ptrCounter->mBoundaryValue;
}
	
void icCounter_reset(icCounter* const ptrCounter)
{
	cCounter_reset(&ptrCounter->mobjCounter);
}

void icCounter_count(icCounter* const ptrCounter)
{
	if (icCounter_isInRange(ptrCounter))
	{
		cCounter_count(&ptrCounter->mobjCounter);
	}
	else
	{
		cCounter_reset(&ptrCounter->mobjCounter);
	}
}

static bool icCounter_isInRange(const icCounter* const ptrCounter)
{
	bool locStatus = false;

	if ( (ptrCounter->mBoundaryValue != cCounter_getStartValue(&ptrCounter->mobjCounter)) &&
			(
			(cCounter_getCountValue(&ptrCounter->mobjCounter) == cCounter_getStartValue(&ptrCounter->mobjCounter)) ||	// specific case: first count
			(tcBoundaryChecker_isInRange(&ptrCounter->mobjBoundaryChecker, cCounter_getCountValue(&ptrCounter->mobjCounter)))
		    ) )
	{
		locStatus = true;
	}
	else
	{
		locStatus = false;
	}

	return locStatus;
}
