#ifndef __cCounter_H__
#define __cCounter_H__

#include "TypeDefinitions.h"

typedef struct _cCounter
{
	uint32_t mCountValue;
	uint32_t mStartValue;
	int32_t mStepValue;
} cCounter;

void cCounter_construct(cCounter* const ptrCounter, const uint32_t StartValue, const int32_t StepValue);
void cCounter_destruct(cCounter* const ptrCounter);

uint32_t cCounter_getCountValue(const cCounter* const ptrCounter);
uint32_t cCounter_getStartValue(const cCounter* const ptrCounter);
int32_t cCounter_getStepValue(const cCounter* const ptrCounter);

void cCounter_setStepValue(cCounter* const ptrCounter, int32_t StepValue);
void cCounter_toggleDirection(cCounter* const ptrCounter);
			
void cCounter_reset(cCounter* const ptrCounter);
void cCounter_count(cCounter* const ptrCounter);
	
#endif  // __cCounter_HPP__
