#include "cController.h"

#include "..\..\Plattform\HAL\BasicIO.h"

static void cController_controlOutput(const cController* const ptrController);
static void cController_controlInput(cController* const ptrController);


void cController_construct(cController* const ptrController)
{
	cUpCounter_construct(&ptrController->mobjUpCounter, 0, 10);
	cDownCounter_construct(&ptrController->mobjDownCounter, 10, 0);
}

void cController_destruct(cController* const ptrController)
{
	// no implementaion
}

void cController_control(cController* const ptrController)
{
	while (true)
	{
		cController_controlOutput(ptrController);
		cController_controlInput(ptrController);
	}
}

static void cController_controlOutput(const cController* const ptrController)
{
	showValue("\nControl Cases - Interface Composition:");
	showValue("\nFirst  counter:");
	showValue("\n CountValue    = %u", cCounter_getCountValue((cCounter*)&ptrController->mobjUpCounter));
	showValue("\n StartValue    = %u", cCounter_getStartValue((cCounter*)&ptrController->mobjUpCounter));
	showValue("\n BoundaryValue = %u", cCounter_getBoundaryValue((cCounter*)&ptrController->mobjUpCounter));
		
	showValue("\nSecond counter:");
	showValue("\n CountValue    = %u", cCounter_getCountValue((cCounter*)&ptrController->mobjDownCounter));
	showValue("\n StartValue    = %u", cCounter_getStartValue((cCounter*)&ptrController->mobjDownCounter));
	showValue("\n BoundaryValue = %u", cCounter_getCountValue((cCounter*)&ptrController->mobjDownCounter));
		
	showValue("\n<A> Count first  counter");
	showValue("\n<B> Reset first  counter");
	showValue("\n<C> Count second counter");
	showValue("\n<D> Reset second counter");
}

static void cController_controlInput(cController* const ptrController)
{
	switch (getCommand())
	{
		case 'A':
			cUpCounter_count(&ptrController->mobjUpCounter);
			break;

		case 'B':
			cCounter_reset((cCounter*)&ptrController->mobjUpCounter);
			break;

		case 'C':
			cDownCounter_count(&ptrController->mobjDownCounter);
			break;

		case 'D':
			cCounter_reset((cCounter*)&ptrController->mobjDownCounter);
			break;

		default:
			showValue("\nError: Unsupported selection!\n");
			break;
	}
}
