#include "cController.h"

#include "..\Counter\cUpCounter.h"
#include "..\Counter\cDownCounter.h"

#include "..\..\Plattform\HAL\BasicIO.h"

#include <stdlib.h>

static void cController_controlOutput(const cController* const ptrController);
static void cController_controlInput(cController* const ptrController);

void cController_construct(cController* const ptrController)
{
	ptrController->mptr_cUpCounter = (cUpCounter*) malloc(sizeof(cUpCounter));
	if (ptrController->mptr_cUpCounter != nullptr)
	{
		cUpCounter_construct(ptrController->mptr_cUpCounter, 0, 10);
	}
	
	ptrController->mptr_cDownCounter = (cDownCounter*) malloc(sizeof(cDownCounter));
	if (ptrController->mptr_cDownCounter != nullptr)
	{
		cDownCounter_construct(ptrController->mptr_cDownCounter, 10, 0);
	}
}

void cController_destruct(cController* const ptrController)
{
	// no implementation
}

cUpCounter* cController_get_ptr_cUpCounter(const cController* const ptrController)
{
	return ptrController->mptr_cUpCounter;
}

cDownCounter* cController_get_ptr_cDownCounter(const cController* const ptrController)
{
	return ptrController->mptr_cDownCounter;
}

void cController_control(cController* const ptrController)
{
	while (true)
	{
		cController_controlOutput(ptrController);
		cController_controlInput(ptrController);
	}
}

static void cController_controlOutput(const cController* const ptrController)
{
	showValue("\nControl Cases - Interface Aggregation:");
	if (ptrController->mptr_cUpCounter != nullptr)
	{
		showValue("\nFirst  counter:");
		showValue("\n CountValue    = %u", cCounter_getCountValue((cCounter*)ptrController->mptr_cUpCounter));
		showValue("\n StartValue    = %u", cCounter_getStartValue((cCounter*)ptrController->mptr_cUpCounter));
		showValue("\n BoundaryValue = %u", cCounter_getBoundaryValue((cCounter*)ptrController->mptr_cUpCounter));
	}
	if (ptrController->mptr_cDownCounter != nullptr)
	{
		showValue("\nSecond counter:");
		showValue("\n CountValue    = %u", cCounter_getCountValue((cCounter*)ptrController->mptr_cDownCounter));
		showValue("\n StartValue    = %u", cCounter_getStartValue((cCounter*)ptrController->mptr_cDownCounter));
		showValue("\n BoundaryValue = %u", cCounter_getBoundaryValue((cCounter*)ptrController->mptr_cDownCounter));
	}
	showValue("\n<A> Count first  counter");
	showValue("\n<B> Reset first  counter");
	showValue("\n<C> Count second counter");
	showValue("\n<D> Reset second counter");
}

static void cController_controlInput(cController* const ptrController)
{
	switch (getCommand())
	{
		case 'A':
			if (ptrController->mptr_cUpCounter != nullptr)
			{
				cUpCounter_count(ptrController->mptr_cUpCounter);
			}
			break;

		case 'B':
			if (ptrController->mptr_cUpCounter != nullptr)
			{
				cCounter_reset((cCounter*)ptrController->mptr_cUpCounter);
			}
			break;

		case 'C':
			if (ptrController->mptr_cDownCounter != nullptr)
			{
				cDownCounter_count(ptrController->mptr_cDownCounter);
			}
			break;

		case 'D':
			if (ptrController->mptr_cDownCounter != nullptr)
			{
				cCounter_reset((cCounter*)ptrController->mptr_cDownCounter);
			}
			break;

		default:
			showValue("\nError: Unsupported selection!\n");
			break;
	}
}
