#include "cUpCounter.hpp"

namespace Counter
{
	cUpCounter::cUpCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept :
		cCounter(StartValue, BoundaryValue)
	{
		// nothing to do
	}
	
	void cUpCounter::count(void) noexcept
	{
		if (isInRange())
		{
			count_raw();
		}
		else
		{
			reset();
		}
	}

	bool cUpCounter::isInRange(void) const noexcept
	{
		bool locStatus = false;

		if ((mStartValue != mBoundaryValue) &&
			(mCountValue < mBoundaryValue))
		{
			locStatus = true;
		}
		else
		{
			locStatus = false;
		}

		return locStatus;
	}

	void cUpCounter::count_raw(void) noexcept
	{
		mCountValue++;
	}
}
