#ifndef __cCounter_HPP__
#define __cCounter_HPP__

#include "TypeDefinitions.hpp"

namespace Counter
{
	class cCounter
	{
		public:
			uint32_t getCountValue(void) const noexcept;
			uint32_t getStartValue(void) const noexcept;
			uint32_t getBoundaryValue(void) const noexcept;
			void reset(void) noexcept;
		
		protected:
			uint32_t mCountValue;
			const uint32_t mStartValue;
			const uint32_t mBoundaryValue;

			explicit cCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept;
			~cCounter() noexcept =default;
	};
}
#endif  // __cCounter_HPP__
