#ifndef __tcController_HPP__
#define __tcController_HPP__

#include "TypeDefinitions.hpp"

#include "..\..\Plattform\HAL\BasicIO.hpp"
using namespace Plattform::HAL;

namespace Controller
{
	template<typename CounterA_T, typename CounterB_T>
	class tcController
	{
		public:
			explicit tcController(void) noexcept;
			~tcController() noexcept =default;
			
			void control(void) noexcept;

		private:
			CounterA_T mobjCounterA;
			CounterB_T mobjCounterB;

			void controlOutput(void) noexcept;
			void controlInput(void) noexcept;
	};

	template<typename CounterA_T, typename CounterB_T>
	tcController<CounterA_T, CounterB_T>::tcController(void) noexcept :
		mobjCounterA(0, 10),
		mobjCounterB(10, 0)
	{
		// nothing to do
	}

	template<typename CounterA_T, typename CounterB_T>
	void tcController<CounterA_T, CounterB_T>::control(void) noexcept
	{
		while (true)
		{
			controlOutput();
			controlInput();
		}
	}
	
	template<typename CounterA_T, typename CounterB_T>
	void tcController<CounterA_T, CounterB_T>::controlOutput(void) noexcept
	{
		showValue("\nControl Cases - Interface Template Parameter:");
		showValue("\nFirst  counter:");
		showValue("\n CountValue    = ", mobjCounterA.getCountValue());
		showValue("\n StartValue    = ", mobjCounterA.getStartValue());
		showValue("\n BoundaryValue = ", mobjCounterA.getBoundaryValue());
		showValue("\nSecond counter:");
		showValue("\n CountValue    = ", mobjCounterB.getCountValue());
		showValue("\n StartValue    = ", mobjCounterB.getStartValue());
		showValue("\n BoundaryValue = ", mobjCounterB.getBoundaryValue());
		showValue("\n<A> Count first  counter");
		showValue("\n<B> Reset first  counter");
		showValue("\n<C> Count second counter");
		showValue("\n<D> Reset second counter");
	}
	
	template<typename CounterA_T, typename CounterB_T>
	void tcController<CounterA_T, CounterB_T>::controlInput(void) noexcept
	{
		switch (getCommand())
		{
			case 'A':
				mobjCounterA.count();
				break;

			case 'B':
				mobjCounterA.reset();
				break;

			case 'C':
				mobjCounterB.count();
				break;

			case 'D':
				mobjCounterB.reset();
				break;

			default:
				showValue("\nError: Unsupported selection!\n");
				break;
		}
	}
}
#endif  // __tcController_HPP__
