#ifndef __icCounter_HPP__
#define __icCounter_HPP__

#include "TypeDefinitions.hpp"

namespace Counter
{
	class icCounter
	{
		public:	
			uint32_t getCountValue(void) const noexcept;
			uint32_t getStartValue(void) const noexcept;
			uint32_t getBoundaryValue(void) const noexcept;

			void reset(void) noexcept;
			void count(void) noexcept;

		protected:
			uint32_t mCountValue;
			const uint32_t mStartValue;
			const uint32_t mBoundaryValue;

			icCounter(const uint32_t StartValue, const uint32_t BondaryValue) noexcept;
			virtual ~icCounter() noexcept =default;
		
		private:
			virtual bool isInRange(void) const noexcept =0;
			virtual void count_raw(void) noexcept =0;
	};
}

#endif  // __icCounter_HPP__
