#include "icCounter.hpp"

namespace Counter
{
	icCounter::icCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept :
		mCountValue(StartValue),
		mStartValue(StartValue),
		mBoundaryValue(BoundaryValue)
	{
		// nothing to do
	}
	
	uint32_t icCounter::getCountValue(void) const noexcept
	{
		return mCountValue;
	}
		
	uint32_t icCounter::getStartValue(void) const noexcept
	{
		return mStartValue;
	}
	
	uint32_t icCounter::getBoundaryValue(void) const noexcept
	{
		return mBoundaryValue;
	}
	
	void icCounter::reset() noexcept
	{
		mCountValue = mStartValue;
	}

	void icCounter::count() noexcept
	{
		if (isInRange())
		{
			count_raw();
		}
		else
		{
			reset();
		}
	}
}
