#include "cUpCounter.hpp"

namespace Counter
{
	cUpCounter::cUpCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept :
		icCounter(StartValue, BoundaryValue)
	{
		// nothing to do
	}

	bool cUpCounter::isInRange(void) const noexcept
	{
		bool locStatus = false;

		if ((mStartValue != mBoundaryValue) &&
			(mCountValue < mBoundaryValue))
		{
			locStatus = true;
		}
		else
		{
			locStatus = false;
		}

		return locStatus;
	}
	
	void cUpCounter::count_raw(void) noexcept
	{
		mCountValue++;
	}
}
