#include "cDownCounter.hpp"

namespace Counter
{
	cDownCounter::cDownCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept :
		icCounter(StartValue, BoundaryValue)
	{
		// nothing to do
	}

	bool cDownCounter::isInRange(void) const noexcept
	{
		bool locStatus = false;

		if ((mStartValue != mBoundaryValue) &&
			(mCountValue > mBoundaryValue))
		{
			locStatus = true;
		}
		else
		{
			locStatus = false;
		}

		return locStatus;
	}
	
	void cDownCounter::count_raw(void) noexcept
	{
		mCountValue--;
	}
}
