#ifndef __tcBoundaryChecker_HPP__
#define __tcBoundaryChecker_HPP__

namespace Counter
{
	template<typename Type_T>
	class tcBoundaryChecker
	{
		public:
			//explicit tcBoundaryChecker(void) noexcept;
			explicit tcBoundaryChecker(const Type_T MinValue, const Type_T MaxValue) noexcept;
			~tcBoundaryChecker() noexcept =default;

			void setMinValue(const Type_T MinValue) noexcept;
			void setMaxValue(const Type_T MaxValue) noexcept;

			Type_T getMinValue(void) const noexcept;
			Type_T getMaxValue(void) const noexcept;
			
			bool isInRange(const Type_T ValueToCheck) const noexcept;

		private:
			Type_T mMinValue;
			Type_T mMaxValue;
	};

	//template<typename Type_T>
	//tcBoundaryChecker<Type_T>::tcBoundaryChecker(void) noexcept :
	//	mMinValue(0),
	//	mMaxValue(0)
	//{
	//	// nothing to do
	//}

	template<typename Type_T>
	tcBoundaryChecker<Type_T>::tcBoundaryChecker(const Type_T MinValue, const Type_T MaxValue) noexcept :
		mMinValue(MinValue),
		mMaxValue(MaxValue)
	{
		// some error cases
	}

	template<typename Type_T>
	void tcBoundaryChecker<Type_T>::setMinValue(const Type_T MinValue) noexcept
	{
		mMinValue = MinValue;
	}

	template<typename Type_T>
	void tcBoundaryChecker<Type_T>::setMaxValue(const Type_T MaxValue) noexcept
	{
		mMaxValue = MaxValue;
	}

	template<typename Type_T>
	Type_T tcBoundaryChecker<Type_T>::getMinValue(void) const noexcept
	{
		return mMinValue;
	}
	
	template<typename Type_T>
	Type_T tcBoundaryChecker<Type_T>::getMaxValue(void) const noexcept
	{
		return mMaxValue;
	}

	template<typename Type_T>
	bool tcBoundaryChecker<Type_T>::isInRange(const Type_T ValueToCheck) const noexcept
	{
		bool locStatus = false;

		if ( (mMinValue < mMaxValue) &&
			 (ValueToCheck > mMinValue) &&
			 (ValueToCheck < mMaxValue) )
		{
			locStatus = true;
		}
		else
		{
			locStatus = false;
		}

		return locStatus;
	}
}
#endif  // __tcBoundaryChecker_HPP__
