#ifndef __icCounter_HPP__
#define __icCounter_HPP__

#include "TypeDefinitions.hpp"

#include "cCounter.hpp"
#include "tcBoundaryChecker.hpp"

namespace Counter
{
	class icCounter
	{
		public:
			explicit icCounter(const uint32_t StartValue, const uint32_t BoundaryValue, const int32_t StepValue) noexcept;
			~icCounter() noexcept =default;
			
			uint32_t getCountValue(void) const noexcept;
			uint32_t getStartValue(void) const noexcept;
			uint32_t getBoundaryValue(void) const noexcept;

			void reset(void) noexcept;
			void count(void) noexcept;

		private:
			const uint32_t mBoundaryValue;
			cCounter mobjCounter;
			const tcBoundaryChecker<uint32_t> mobjBoundaryChecker;

			bool isInRange(void) const noexcept;
	};
}

#endif  // __icCounter_HPP__
