#include "icCounter.hpp"

#include "iostream"

namespace Counter
{
	icCounter::icCounter(const uint32_t StartValue, const uint32_t BoundaryValue, const int32_t StepValue) noexcept :
		mBoundaryValue(BoundaryValue),
		mobjCounter(StartValue, StepValue),
		
		mobjBoundaryChecker((StartValue < BoundaryValue) ? StartValue    : (StartValue > BoundaryValue) ? BoundaryValue : 0,
		                    (StartValue < BoundaryValue) ? BoundaryValue : (StartValue > BoundaryValue) ? StartValue    : 0)
		
	{
		std::cout << "\nMinValue = " << mobjBoundaryChecker.getMinValue();
		std::cout << "\nMaxValue = " << mobjBoundaryChecker.getMaxValue();		
	}

	uint32_t icCounter::getCountValue(void) const noexcept
	{
		return mobjCounter.getCountValue();
	}

	uint32_t icCounter::getStartValue(void) const noexcept
	{
		return mobjCounter.getStartValue();
	}

	uint32_t icCounter::getBoundaryValue(void) const noexcept
	{
		return mBoundaryValue;
	}
	
	void icCounter::reset(void) noexcept
	{
		mobjCounter.reset();
	}

	void icCounter::count(void) noexcept
	{
		if (isInRange())
		{
			mobjCounter.count();
		}
		else
		{
			mobjCounter.reset();
		}
	}

	bool icCounter::isInRange(void) const noexcept
	{
		bool locStatus = false;

		if ( (mBoundaryValue != mobjCounter.getStartValue()) &&
			 (
			 (mobjCounter.getCountValue() == mobjCounter.getStartValue()) ||	// specific case: first count
			 (mobjBoundaryChecker.isInRange(mobjCounter.getCountValue()))
		     ) )
		{
			locStatus = true;
		}
		else
		{
			locStatus = false;
		}

		return locStatus;
	}
}
