#ifndef __cCounter_HPP__
#define __cCounter_HPP__

#include "TypeDefinitions.hpp"

namespace Counter
{
	class cCounter
	{
		public:
			explicit cCounter(const uint32_t StartValue, const int32_t StepValue) noexcept;
			~cCounter() = default;

			uint32_t getCountValue(void) const noexcept;
			uint32_t getStartValue(void) const noexcept;
			int32_t getStepValue(void) const noexcept;

			void setStepValue(int32_t StepValue) noexcept;
			void toggleDirection(void) noexcept;
			
			void reset(void) noexcept;
			void count(void) noexcept;
			
		private:
			uint32_t mCountValue;
			const uint32_t mStartValue;
			int32_t mStepValue;			
	};
}
#endif  // __cCounter_HPP__
