#include "cCounter.hpp"

namespace Counter
{
	cCounter::cCounter(const uint32_t StartValue, const int32_t StepValue) noexcept :
		mCountValue(StartValue),
		mStartValue(StartValue),
		mStepValue(StepValue)
	{
		// nothing to do
	}
	
	uint32_t cCounter::getCountValue(void) const noexcept
	{
		return mCountValue;
	}

	uint32_t cCounter::getStartValue(void) const noexcept
	{
		return mStartValue;
	}

	int32_t cCounter::getStepValue(void) const noexcept
	{
		return mStepValue;
	}

	void cCounter::setStepValue(int32_t StepValue) noexcept
	{
		mStepValue = StepValue;
	}

	void cCounter::toggleDirection(void) noexcept
	{
		mStepValue = mStepValue * -1;
	}

	void cCounter::reset(void) noexcept
	{
		mCountValue = mStartValue;
	}

	void cCounter::count(void) noexcept
	{
		mCountValue = mCountValue + mStepValue;
	}
}
