#include "cController.hpp"
#include "..\Counter\icCounter.hpp"

#include "..\..\Plattform\HAL\BasicIO.hpp"
using namespace Plattform::HAL;

namespace Controller
{
	cController::cController(void) noexcept//:
		//mptr_icCounter{nullptr, nullptr}
	{
		for (auto& value : mptr_icCounter)
		{
			value = nullptr;
		}
	}

	void cController::set_ptr_icCounter(icCounter* const ptr_icCounter, const uint32_t Index) noexcept
	{
		if (Index < mArrayLength)
		{
			mptr_icCounter[Index] = ptr_icCounter;
		}
	}

	void cController::control(void) noexcept
	{
		while (true)
		{
			controlOutput();
			controlInput();
		}
	}

	void cController::controlOutput(void) noexcept
	{
		showValue("\nControl Cases - Interface Facade Pattern:");
		if (mptr_icCounter[0] != nullptr)
		{
			showValue("\nFirst  counter:");
			showValue("\n CountValue    = ", mptr_icCounter[0]->getCountValue());
			showValue("\n StartValue    = ", mptr_icCounter[0]->getStartValue());
			showValue("\n BoundaryValue = ", mptr_icCounter[0]->getBoundaryValue());
		}
		if (mptr_icCounter[1] != nullptr)
		{
			showValue("\nSecond counter:");
			showValue("\n CountValue    = ", mptr_icCounter[1]->getCountValue());
			showValue("\n StartValue    = ", mptr_icCounter[1]->getStartValue());
			showValue("\n BoundaryValue = ", mptr_icCounter[1]->getBoundaryValue());
		}
		showValue("\n<A> Count first  counter");
		showValue("\n<B> Reset first  counter");
		showValue("\n<C> Count second counter");
		showValue("\n<D> Reset second counter");
	}

	void cController::controlInput(void) noexcept
	{
		switch (getCommand())
		{
		case 'A':
			if (mptr_icCounter[0] != nullptr)
			{
				mptr_icCounter[0]->count();
			}
			break;

		case 'B':
			if (mptr_icCounter[0] != nullptr)
			{
				mptr_icCounter[0]->reset();
			}
			break;

		case 'C':
			if (mptr_icCounter[1] != nullptr)
			{
				mptr_icCounter[1]->count();
			}
			break;

		case 'D':
			if (mptr_icCounter[1] != nullptr)
			{
				mptr_icCounter[1]->reset();
			}
			break;

		default:
			showValue("\nError: Unsupported selection!\n");
			break;
		}
	}
}