#include "cController.hpp"

#include "..\..\Plattform\HAL\BasicIO.hpp"
using namespace Plattform::HAL;

namespace Controller
{
	cController::cController(void) noexcept :
		mobjUpCounter(0, 10),
		mobjDownCounter(10, 0)
	{
		// nothing to do
	}

	void cController::control(void) noexcept
	{
		while (true)
		{
			controlOutput();
			controlInput();
		}
	}

	void cController::controlOutput(void) noexcept
	{
		showValue("\nControl Cases - Interface Composition:");
		showValue("\nFirst  counter:");
		showValue("\n CountValue    = ", mobjUpCounter.getCountValue());
		showValue("\n StartValue    = ", mobjUpCounter.getStartValue());
		showValue("\n BoundaryValue = ", mobjUpCounter.getBoundaryValue());
		
		
		showValue("\nSecond counter:");
		showValue("\n CountValue    = ", mobjDownCounter.getCountValue());
		showValue("\n StartValue    = ", mobjDownCounter.getStartValue());
		showValue("\n BoundaryValue = ", mobjDownCounter.getBoundaryValue());
		
		showValue("\n<A> Count first  counter");
		showValue("\n<B> Reset first  counter");
		showValue("\n<C> Count second counter");
		showValue("\n<D> Reset second counter");
	}

	void cController::controlInput(void) noexcept
	{
		switch (getCommand())
		{
			case 'A':
				mobjUpCounter.count();
				break;

			case 'B':
				mobjUpCounter.reset();
				break;

			case 'C':
				mobjDownCounter.count();
				break;

			case 'D':
				mobjDownCounter.reset();
				break;

			default:
				showValue("\nError: Unsupported selection!\n");
				break;
		}
	}
}
