#ifndef __ticCounter_HPP__
#define __ticCounter_HPP__

#include "TypeDefinitions.hpp"

namespace Counter
{
	template <typename Realization_T>
	class ticCounter
	{
		public:
			uint32_t getCountValue(void) const noexcept;
			uint32_t getStartValue(void) const noexcept;
			uint32_t getBoundaryValue(void) const noexcept;
			void reset(void) noexcept;
			void count(void) noexcept;

		protected:
			uint32_t mCountValue;
			const uint32_t mStartValue;
			const uint32_t mBoundaryValue;

			explicit ticCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept;
			~ticCounter() noexcept =default;
	};

	template <typename Realization_T>
	ticCounter<Realization_T>::ticCounter(const uint32_t StartValue, const uint32_t BoundaryValue) noexcept :
		mCountValue(StartValue),
		mStartValue(StartValue),
		mBoundaryValue(BoundaryValue)
		
	{
		// nothing to do
	}

	template <typename Realization_T>
	uint32_t ticCounter<Realization_T>::getCountValue(void) const noexcept
	{
		return mCountValue;
	}

	template <typename Realization_T>
	uint32_t ticCounter<Realization_T>::getStartValue(void) const noexcept
	{
		return mStartValue;
	}

	template <typename Realization_T>
	uint32_t ticCounter<Realization_T>::getBoundaryValue(void) const noexcept
	{
		return mBoundaryValue;
	}

	template <typename Realization_T>
	void ticCounter<Realization_T>::reset() noexcept
	{
		mCountValue = mStartValue;
	}

	template <typename Realization_T>
	void ticCounter<Realization_T>::count() noexcept
	{
		static_cast<Realization_T*>(this)->count();
	}
}
#endif  // __ticCounter_HPP__
