#include "cController.hpp"

#include "..\Counter\cUpCounter.hpp"
#include "..\Counter\cDownCounter.hpp"
using Counter::cUpCounter;
using Counter::cDownCounter;

#include "..\..\Plattform\HAL\BasicIO.hpp"
using namespace Plattform::HAL;

namespace Controller
{
	cController::cController(void) noexcept :
		mptr_cUpCounter(new(std::nothrow) cUpCounter(0, 10)),
		mptr_cDownCounter(new(std::nothrow) cDownCounter(10, 0))
	{
		// no implementation
	}

	cUpCounter* cController::get_ptr_cUpCounter(void) const noexcept
	{
		return mptr_cUpCounter;
	}

	cDownCounter* cController::get_ptr_cDownCounter(void) const noexcept
	{
		return mptr_cDownCounter;
	}

	void cController::control(void) noexcept
	{
		while (true)
		{
			controlOutput();
			controlInput();
		}
	}

	void cController::controlOutput(void) noexcept
	{
		showValue("\nControl Cases - Interface Aggregation:");
		if (mptr_cUpCounter != nullptr)
		{
			showValue("\nFirst  counter:");
			showValue("\n CountValue    = ", mptr_cUpCounter->getCountValue());
			showValue("\n StartValue    = ", mptr_cUpCounter->getStartValue());
			showValue("\n BoundaryValue = ", mptr_cUpCounter->getBoundaryValue());
		}
		if (mptr_cDownCounter != nullptr)
		{
			showValue("\nSecond counter:");
			showValue("\n CountValue    = ", mptr_cDownCounter->getCountValue());
			showValue("\n StartValue    = ", mptr_cDownCounter->getStartValue());
			showValue("\n BoundaryValue = ", mptr_cDownCounter->getBoundaryValue());
		}
		showValue("\n<A> Count first  counter");
		showValue("\n<B> Reset first  counter");
		showValue("\n<C> Count second counter");
		showValue("\n<D> Reset second counter");
	}

	void cController::controlInput(void) noexcept
	{
		switch (getCommand())
		{
			case 'A':
				if (mptr_cUpCounter != nullptr)
				{
					mptr_cUpCounter->count();
				}
				break;

			case 'B':
				if (mptr_cUpCounter != nullptr)
				{
					mptr_cUpCounter->reset();
				}
				break;

			case 'C':
				if (mptr_cDownCounter != nullptr)
				{
					mptr_cDownCounter->count();
				}
				break;

			case 'D':
				if (mptr_cDownCounter != nullptr)
				{
					mptr_cDownCounter->reset();
				}
				break;

			default:
				showValue("\nError: Unsupported selection!\n");
				break;
		}
	}
}
